#!/bin/bash

appname=`basename $0 | sed s,\.sh$,,`

dirname=`dirname $0`
tmp="${dirname#?}"

if [ "${dirname%$tmp}" != "/" ]; then
dirname=$PWD/$dirname
fi

export LD_LIBRARY_PATH=$dirname/Qt_Libraries
export QT_PLUGIN_PATH=$dirname/Qt_Libraries/plugins
export QML_IMPORT_PATH=$dirname/Qt_Libraries/qml
export QML2_IMPORT_PATH=$dirname/Qt_Libraries/qml
export QT_QPA_PLATFORM_PLUGIN_PATH=$dirname/Qt_Libraries/plugins/platforms
export QT_QPA_EGLFS_ALWAYS_SET_MODE="1"
export QT_QPA_EGLFS_KMS_ATOMIC=1

PLATFORM="xcb"

if [ -n "$1" ]; then
	PLATFORM="$1"
fi

#echo "platform: ${PLATFORM}"

exec $dirname/$appname -platform "${PLATFORM}" &>/dev/null &
